/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cellbio.svg;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class OutputParamDialog
extends JDialog
implements ActionListener {
    private JLabel imgFileLabel;
    private JComboBox imgFileMode;
    private JLabel compQualLabel;
    private JSpinner compQual;
    private JLabel resampLabel;
    private JLabel resampLabel2;
    private JCheckBox resampCheck;
    private JSpinner resampLevel;
    private JSpinner resampLevel2;
    private JCheckBox procEmbedCheck;
    private JLabel procEmbedLabel;
    private JSpinner procEmbedLevel;
    private JButton ok;
    private JButton cancel;
    private boolean wasOKd = false;

    public OutputParamDialog() {
        this.setup();
    }

    @Override
    public synchronized void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.imgFileMode) {
            this.compQual.setEnabled(this.imgFileMode.getSelectedIndex() > 0);
            this.compQualLabel.setEnabled(this.imgFileMode.getSelectedIndex() > 0);
        }
        if (e.getSource() == this.ok) {
            System.err.println("ok");
            this.wasOKd = true;
            this.setVisible(false);
            this.notifyAll();
        }
        if (e.getSource() == this.cancel) {
            System.err.println("cancel");
            this.setVisible(false);
            this.notifyAll();
        }
        if (e.getSource() == this.procEmbedCheck) {
            this.procEmbedLabel.setEnabled(this.procEmbedCheck.getModel().isSelected());
            this.procEmbedLevel.setEnabled(this.procEmbedCheck.getModel().isSelected());
            this.notifyAll();
        }
    }

    public synchronized void showAndWait() {
        this.setVisible(true);
        while (this.isVisible()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean wasOKd() {
        return this.wasOKd;
    }

    public String getImgFileMode() {
        switch (this.imgFileMode.getSelectedIndex()) {
            case 0: {
                return "png";
            }
            case 1: {
                return "jpeg";
            }
            case 2: {
                return "mix";
            }
        }
        throw new IllegalArgumentException("Invalid image type selecetd");
    }

    public float getCompressionQuality() {
        return ((Double)this.compQual.getModel().getValue()).floatValue();
    }

    public boolean getDoResample() {
        return this.resampCheck.getModel().isSelected();
    }

    public float getTargetRes() {
        return ((Double)this.resampLevel.getModel().getValue()).floatValue();
    }

    public float getMaxRes() {
        return ((Double)this.resampLevel2.getModel().getValue()).floatValue();
    }

    public long getEmbeddedImageSizeMin() {
        if (!this.procEmbedCheck.getModel().isSelected()) {
            return -1L;
        }
        return ((Integer)this.procEmbedLevel.getModel().getValue()).longValue() * 1024L;
    }

    private void setup() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosing(WindowEvent we) {
                Window window = we.getWindow();
                synchronized (window) {
                    OutputParamDialog.this.setVisible(false);
                    we.getWindow().notifyAll();
                }
            }
        });
        this.setLocationRelativeTo(null);
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        this.imgFileLabel = new JLabel("Image encoding type:");
        this.imgFileMode = new JComboBox<String>(new String[]{"PNG", "JPEG", "Most efficient"});
        this.imgFileMode.setAlignmentX(0.0f);
        this.imgFileMode.addActionListener(this);
        this.compQualLabel = new JLabel("Compression level\n(high, better quality; low, smaller file):");
        this.compQualLabel.setEnabled(this.imgFileMode.getSelectedIndex() == 1);
        this.compQual = new JSpinner(new SpinnerNumberModel(0.8f, 0.0, 1.0, 0.1f));
        this.compQual.setAlignmentX(0.0f);
        this.compQual.setEnabled(this.imgFileMode.getSelectedIndex() > 0);
        this.resampLabel = new JLabel("Downsample to (px/mm):");
        this.resampLabel2 = new JLabel("For images greater than (px/mm):");
        this.resampCheck = new JCheckBox("Do resampling?");
        this.resampLevel = new JSpinner(new SpinnerNumberModel(11.811f, 0.0, 1000.0, 0.1f));
        this.resampLevel.setAlignmentX(0.0f);
        this.resampLevel2 = new JSpinner(new SpinnerNumberModel(15.748f, 0.0, 1000.0, 0.1f));
        this.resampLevel2.setAlignmentX(0.0f);
        this.procEmbedCheck = new JCheckBox("Process embedded images?");
        this.procEmbedCheck.addActionListener(this);
        this.procEmbedLabel = new JLabel("For images greater than (kB):");
        this.procEmbedLabel.setEnabled(false);
        this.procEmbedLevel = new JSpinner(new SpinnerNumberModel(250, 0, 5000, 10));
        this.procEmbedLevel.setAlignmentX(0.0f);
        this.procEmbedLevel.setEnabled(false);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.setAlignmentX(0.0f);
        this.ok = new JButton("OK");
        this.ok.addActionListener(this);
        this.ok.setDefaultCapable(true);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        buttons.add(Box.createHorizontalStrut(10));
        buttons.add(this.ok);
        buttons.add(Box.createHorizontalStrut(10));
        buttons.add(this.cancel);
        this.add(Box.createVerticalStrut(5));
        this.add(this.imgFileLabel);
        this.add(this.imgFileMode);
        this.add(Box.createVerticalStrut(10));
        this.add(this.compQualLabel);
        this.add(this.compQual);
        this.add(Box.createVerticalStrut(10));
        this.add(this.resampCheck);
        this.add(this.resampLabel);
        this.add(this.resampLevel);
        this.add(this.resampLabel2);
        this.add(this.resampLevel2);
        this.add(Box.createVerticalStrut(10));
        this.add(this.procEmbedCheck);
        this.add(this.procEmbedLabel);
        this.add(this.procEmbedLevel);
        this.add(Box.createVerticalStrut(10));
        this.add(buttons);
        this.add(Box.createVerticalStrut(5));
        this.pack();
    }
}

