/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cellbio.svg;

import edu.emory.cellbio.svg.EmbedAndCropException;
import edu.emory.cellbio.svg.OutputParamDialog;
import ij.IJ;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EmbedAndCrop {
    private String imgFileType = "png";
    private float compQual = 0.8f;
    private boolean doResampling = false;
    private double targetRes = 11.811;
    private double maxRes = 15.748;
    private long embeddedImageSizeMin = -1L;
    private final boolean VERBOSE = false;

    public void runInkscapeExtension(String[] args) {
        Object input = null;
        Object output = null;
        boolean saveAs = false;
        try {
            this.parseArgs(args);
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (t.getMessage().contains("Canceled by user")) {
                System.exit(0);
            }
            JOptionPane.showMessageDialog(null, t.getMessage(), "Error: " + t.getMessage(), 0);
            System.exit(1);
        }
        System.exit(0);
    }

    public boolean runWithoutExit(String[] args) {
        Object input = null;
        Object output = null;
        boolean saveAs = false;
        try {
            this.parseArgs(args);
        }
        catch (Throwable t) {
            t.printStackTrace();
            JOptionPane.showMessageDialog(null, t.getMessage(), "Error: " + t.getMessage(), 0);
            return false;
        }
        return true;
    }

    private void parseArgs(String[] args) {
        File input = null;
        File output = null;
        boolean saveAs = false;
        try {
            boolean typeLoaded = false;
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    String next2;
                    String token = args[i].trim();
                    String next = args.length > i + 1 ? args[i + 1] : null;
                    String string = next2 = args.length > i + 2 ? args[i + 2] : null;
                    if (token == null || token.isEmpty()) continue;
                    if (token.equals("-o") && next != null) {
                        output = new File(next);
                        ++i;
                        continue;
                    }
                    if (token.equals("-s")) {
                        saveAs = true;
                        continue;
                    }
                    if (token.equals("-t") && next != null) {
                        this.imgFileType = next;
                        this.checkImageOutputType();
                        typeLoaded = true;
                        ++i;
                        continue;
                    }
                    if (token.equals("-q") && next != null) {
                        if (!typeLoaded) {
                            throw new EmbedAndCropException("Can't set quality without image type");
                        }
                        this.compQual = Float.parseFloat(next);
                        ++i;
                        continue;
                    }
                    if (token.equals("-r")) {
                        if (next != null) {
                            this.targetRes = Double.parseDouble(next);
                            ++i;
                            if (next2 != null && !next2.startsWith("-")) {
                                this.maxRes = Double.parseDouble(next2);
                                ++i;
                            } else {
                                this.maxRes = 1.0 * this.targetRes;
                            }
                        }
                        this.doResampling = true;
                        continue;
                    }
                    if (token.equals("-e") && next != null) {
                        this.embeddedImageSizeMin = this.processFileSize(next);
                        ++i;
                        continue;
                    }
                    if (i != 0) continue;
                    input = new File(token);
                }
            }
            if (input == null) {
                input = this.openDialog();
            }
            if (!typeLoaded) {
                this.getOutputParams();
            }
            if (input == null || !input.canRead()) {
                throw new EmbedAndCropException("Can't read temporary input file " + input != null ? input.getPath() : "<null>");
            }
            Document dom = this.readSVG(input);
            this.process(dom, input.getParent());
            if (saveAs) {
                this.saveAs(dom);
            } else if (output != null) {
                this.save(dom, output);
            } else {
                this.SVGToStream(dom, System.out);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void process(Document dom, String basePath) throws EmbedAndCropException {
        NodeList images = dom.getElementsByTagName("image");
        for (int i = 0; i < images.getLength(); ++i) {
            Element clip;
            Node img = images.item(i);
            if (img.getNodeType() != 1) continue;
            System.err.println("## Working on image " + ((Element)img).getAttribute("id"));
            Element parent = (Element)img.getParentNode();
            if (parent.getTagName().equals("mask")) {
                System.err.println("This image appears to BE a mask and will be removed!");
                parent.removeChild(img);
                continue;
            }
            String mask = ((Element)img).getAttribute("mask");
            if (mask != null && !mask.isBlank()) {
                System.err.println("This image has a mask, which will be removed to ensure compatability. (" + mask + ")");
                ((Element)img).removeAttribute("mask");
            }
            if ((clip = this.getClipPath((Element)img, dom)) != null) {
                this.processImg((Element)img, clip, basePath);
                continue;
            }
            this.processImg((Element)img, null, basePath);
        }
    }

    private void SVGToStream(Document dom, OutputStream os) throws EmbedAndCropException {
        try {
            Transformer xmlt = TransformerFactory.newInstance().newTransformer();
            xmlt.setOutputProperty("method", "xml");
            xmlt.transform(new DOMSource(dom), new StreamResult(os));
            os.close();
        }
        catch (Throwable t) {
            throw new EmbedAndCropException("XML write error: " + t);
        }
    }

    private void getOutputParams() throws EmbedAndCropException {
        OutputParamDialog opd = new OutputParamDialog();
        opd.showAndWait();
        if (!opd.wasOKd()) {
            throw new EmbedAndCropException("Canceled by user");
        }
        this.imgFileType = opd.getImgFileMode();
        this.compQual = opd.getCompressionQuality();
        this.doResampling = opd.getDoResample();
        this.maxRes = opd.getMaxRes();
        this.targetRes = opd.getTargetRes();
        this.embeddedImageSizeMin = opd.getEmbeddedImageSizeMin();
        this.checkImageOutputType();
    }

    private void checkImageOutputType() throws EmbedAndCropException {
        switch (this.imgFileType) {
            case "png": 
            case "jpeg": 
            case "mix": {
                return;
            }
        }
        throw new EmbedAndCropException("Unsupported output type: " + this.imgFileType);
    }

    private void saveAs(Document dom) throws EmbedAndCropException {
        JFileChooser fd = new JFileChooser();
        if (fd.showSaveDialog(null) != 0) {
            return;
        }
        File f = fd.getSelectedFile();
        if (f.exists() && JOptionPane.showConfirmDialog(null, "File exists. OK to overwite?", "", 2) != 0) {
            return;
        }
        this.save(dom, f);
    }

    private void save(Document dom, File f) throws EmbedAndCropException {
        try {
            f.getParentFile().mkdirs();
            Transformer xmlt = TransformerFactory.newInstance().newTransformer();
            xmlt.setOutputProperty("method", "xml");
            xmlt.transform(new DOMSource(dom), new StreamResult(f));
        }
        catch (Throwable t) {
            throw new EmbedAndCropException("XML write error: " + t);
        }
    }

    private void processImg(Element img, Element clip, String basePath) throws EmbedAndCropException {
        BufferedImage I;
        double[] cf = new double[]{0.0, 0.0, 0.0, 0.0};
        if (clip != null) {
            cf = this.getCropFraction(img, clip);
        }
        if ((I = this.loadImageData(img, basePath, this.embeddedImageSizeMin)) == null) {
            return;
        }
        this.putImgData(img, I, cf);
    }

    private BufferedImage loadImageData(Element imgElement, String basePath, long embedSizeMin) throws EmbedAndCropException {
        String path = imgElement.getAttribute("xlink:href");
        if (path == null || path.equals("")) {
            path = imgElement.getAttribute("href");
        }
        if (path == null || path.equals("")) {
            throw new EmbedAndCropException("No image file or data!");
        }
        if (path.startsWith("data:image")) {
            if (embedSizeMin < 0L) {
                System.err.println("Skipping embedded image.");
                return null;
            }
            try {
                Map.Entry<BufferedImage, Integer> embeddedImageData = this.readEmbeddedImageData(path);
                BufferedImage img = embeddedImageData.getKey();
                Integer imgSize = embeddedImageData.getValue();
                if ((long)imgSize.intValue() <= embedSizeMin) {
                    System.err.println("Embedded image is below the size limit and will be left as-is.");
                    return null;
                }
                System.err.println("Embedded image is above the size limit and will be processed.");
                return img;
            }
            catch (EmbedAndCropException e) {
                System.err.println(e.getMessage());
                System.err.println("Embedded image will be left as-is.");
                return null;
            }
        }
        if (path.startsWith("file:///")) {
            path = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH).indexOf("win") > 0 ? path.substring(8) : path.substring(7);
        }
        path = path.replace("%20", " ");
        File imf = new File(path = path.replace("%5C", "\\"));
        if (!imf.isAbsolute()) {
            imf = new File(basePath, path);
        }
        if (!imf.canRead()) {
            throw new EmbedAndCropException("Can't read file link: " + path);
        }
        try {
            System.err.println("Loading image from file " + imf.getName());
            Object origImg = null;
            if (origImg == null) {
                return IJ.openImage((String)imf.getAbsolutePath()).getBufferedImage();
            }
        }
        catch (Throwable t) {
            throw new EmbedAndCropException("Problem reading image file; " + t);
        }
        return null;
    }

    private void putImgData(Element img, BufferedImage origImg, double[] crop) throws EmbedAndCropException {
        if (this.doResampling) {
            double[] WH = this.getElementDims(img);
            origImg = this.limitResolution(origImg, WH, this.targetRes, this.maxRes);
        }
        int w = origImg.getWidth();
        int h = origImg.getHeight();
        int[] icrop = new int[]{(int)Math.floor(crop[0] * (double)h), (int)Math.floor(crop[1] * (double)h), (int)Math.floor(crop[2] * (double)w), (int)Math.floor(crop[3] * (double)w)};
        for (int i = 0; i < 4; ++i) {
            icrop[i] = Math.max(icrop[i], 0);
        }
        BufferedImage cropImg = origImg.getSubimage(icrop[2], icrop[0], w - icrop[2] - icrop[3], h - icrop[0] - icrop[1]);
        double[] acrop = new double[]{(double)icrop[0] / (double)h, (double)icrop[1] / (double)h, (double)icrop[2] / (double)w, (double)icrop[3] / (double)w};
        this.adjustImgPlacement(img, acrop);
        ByteArrayOutputStream baos = null;
        String mime = null;
        try {
            ByteArrayOutputStream bytesPng = new ByteArrayOutputStream();
            ByteArrayOutputStream bytesJpg = new ByteArrayOutputStream();
            if (this.imgFileType.equals("jpeg") || this.imgFileType.equals("mix")) {
                ImageWriter iwJpg = ImageIO.getImageWritersByFormatName("jpeg").next();
                ImageWriteParam iwpJpg = iwJpg.getDefaultWriteParam();
                iwpJpg.setCompressionMode(2);
                iwpJpg.setCompressionQuality(this.compQual);
                ImageOutputStream iosJpg = ImageIO.createImageOutputStream(bytesJpg);
                iwJpg.setOutput(iosJpg);
                iwJpg.write(null, new IIOImage(cropImg, null, null), iwpJpg);
                iosJpg.close();
                mime = "jpeg";
                baos = bytesJpg;
            }
            if (this.imgFileType.equals("png") || this.imgFileType.equals("mix")) {
                ImageWriter iwPng = ImageIO.getImageWritersByFormatName("png").next();
                ImageWriteParam iwpPng = iwPng.getDefaultWriteParam();
                ImageOutputStream iosPng = ImageIO.createImageOutputStream(bytesPng);
                iwPng.setOutput(iosPng);
                iwPng.write(null, new IIOImage(cropImg, null, null), iwpPng);
                iosPng.close();
                mime = "png";
                baos = bytesPng;
            }
            if (this.imgFileType.equals("mix")) {
                int sizePng = bytesPng.size();
                int sizeJpg = bytesJpg.size();
                if (sizeJpg < sizePng) {
                    System.err.println("Embedding image as Jpeg.");
                    mime = "jpeg";
                    baos = bytesJpg;
                } else {
                    System.err.println("Embedding image as PNG.");
                    mime = "png";
                    baos = bytesPng;
                }
            }
        }
        catch (Throwable t) {
            throw new EmbedAndCropException("Problem writing/encoding image data; " + t);
        }
        if (baos == null) {
            throw new EmbedAndCropException("Unable to determine image type: " + this.imgFileType);
        }
        String result = "data:image/" + mime + ";base64," + Base64.encodeBase64String((byte[])baos.toByteArray());
        img.setAttribute("xlink:href", result);
    }

    private Map.Entry<BufferedImage, Integer> readEmbeddedImageData(String imgString) throws EmbedAndCropException {
        BufferedImage img = null;
        Integer imgSize = null;
        if (imgString.startsWith("data:image/png;") || imgString.startsWith("data:image/jpeg;")) {
            if (!(imgString = imgString.replaceFirst("data:image/((png)|(jpeg));", "")).startsWith("base64,")) {
                throw new EmbedAndCropException("Unable to decode image: " + imgString.substring(0, 25));
            }
            imgString = imgString.substring(7);
            byte[] imgBytes = Base64.decodeBase64((String)imgString);
            imgSize = imgBytes.length;
            ByteArrayInputStream bais = new ByteArrayInputStream(imgBytes);
            try {
                img = ImageIO.read(bais);
            }
            catch (Throwable t) {
                throw new EmbedAndCropException(t.toString());
            }
        } else {
            throw new EmbedAndCropException("Unsupported image format: " + imgString.substring(0, 25));
        }
        return new AbstractMap.SimpleEntry<BufferedImage, Integer>(this.convertToRGB(img), imgSize);
    }

    private BufferedImage convertToRGB(BufferedImage img) {
        if (img.getType() == 1) {
            return img;
        }
        BufferedImage out = new BufferedImage(img.getWidth(), img.getHeight(), 1);
        out.createGraphics().drawImage((Image)img, 0, 0, null);
        return out;
    }

    private void adjustImgPlacement(Element img, double[] crop) {
        double w = Double.valueOf(img.getAttribute("width"));
        double h = Double.valueOf(img.getAttribute("height"));
        double nx = 0.0;
        double ny = 0.0;
        try {
            nx = Double.valueOf(img.getAttribute("x"));
        }
        catch (NumberFormatException e) {
            System.err.println("No x coordinate set, default to 0.");
        }
        try {
            ny = Double.valueOf(img.getAttribute("y"));
        }
        catch (NumberFormatException e) {
            System.err.println("No y coordinate set, default to 0.");
        }
        double nw = w * (1.0 - crop[2] - crop[3]);
        double nh = h * (1.0 - crop[0] - crop[1]);
        img.setAttribute("x", String.valueOf(nx += crop[2] * w));
        img.setAttribute("y", String.valueOf(ny += crop[0] * h));
        img.setAttribute("width", String.valueOf(nw));
        img.setAttribute("height", String.valueOf(nh));
    }

    private double[] getElementDims(Element e) {
        double W = Double.parseDouble(e.getAttribute("width"));
        double H = Double.parseDouble(e.getAttribute("height"));
        Object points = new double[][]{{0.0, 0.0}, {W, 0.0}, {0.0, H}};
        W = (points = (Object)this.transformToDocumentSpace((double[][])points, (Node)e))[1][1] - points[0][1] == 0.0 ? Math.abs(points[1][0] - points[0][0]) : Math.sqrt(Math.pow(points[1][1] - points[0][1], 2.0) + Math.pow(points[1][0] - points[0][0], 2.0));
        H = points[2][0] - points[0][0] == 0.0 ? Math.abs(points[2][1] - points[0][1]) : Math.sqrt(Math.pow(points[2][1] - points[0][1], 2.0) + Math.pow(points[2][0] - points[0][0], 2.0));
        return new double[]{W, H};
    }

    private BufferedImage limitResolution(BufferedImage I, double[] wh, double rTarget, double rMax) {
        double rW = (double)I.getWidth() / wh[0];
        double rH = (double)I.getHeight() / wh[1];
        double sW = Math.min(rTarget / rW, 1.0);
        double sH = Math.min(rTarget / rH, 1.0);
        if (rW > rMax || rH > rMax) {
            System.err.printf("Downsampling by factor of %1$.3f x %2$.3f .\n", sW, sH);
            AffineTransformOp ato = new AffineTransformOp(AffineTransform.getScaleInstance(sW, sH), 3);
            BufferedImage J = ato.createCompatibleDestImage(I, I.getColorModel());
            ato.filter(I, J);
            return J;
        }
        return I;
    }

    private double[] getCropFraction(Element img, Element clip) throws EmbedAndCropException {
        int i;
        double[] imgBounds = this.getRectBounds(img);
        double[][] clipPoints = this.getClipPoints(clip);
        double[] cf = new double[]{1.0, 1.0, 1.0, 1.0};
        if (clipPoints == null || clipPoints.length == 0) {
            for (i = 0; i < 4; ++i) {
                cf[i] = 0.0;
            }
        }
        for (i = 0; i < clipPoints.length; ++i) {
            double[] pf = this.scaleToRectFraction(this.distanceFromRect(clipPoints[i], imgBounds), imgBounds);
            for (int j = 0; j < 4; ++j) {
                cf[j] = Math.min(cf[j], pf[j]);
            }
        }
        return cf;
    }

    private boolean isPointInRect(double[] p, double[] r) {
        return (p[0] < r[0] && p[0] > r[1] || p[0] < r[1] && p[0] > r[0]) && (p[1] < r[2] && p[1] > r[3] || p[1] < r[3] && p[1] > r[2]);
    }

    private double[] distanceFromRect(double[] p, double[] r) {
        double top = Math.min(r[2], r[3]);
        double bot = Math.max(r[2], r[3]);
        double rit = Math.max(r[0], r[1]);
        double lef = Math.min(r[0], r[1]);
        double[] result = new double[]{p[1] - top, bot - p[1], p[0] - lef, rit - p[0]};
        return result;
    }

    private double[] scaleToRectFraction(double[] d, double[] r) {
        d[0] = d[0] / Math.abs(r[2] - r[3]);
        d[1] = d[1] / Math.abs(r[2] - r[3]);
        d[2] = d[2] / Math.abs(r[0] - r[1]);
        d[3] = d[3] / Math.abs(r[0] - r[1]);
        return d;
    }

    private double distanceFromLine(double[] lp0, double[] lp1, double[] x) {
        double[] lpd = new double[]{lp1[0] - lp0[0], lp1[1] - lp0[1]};
        double tMin = (x[0] * lpd[0] + x[1] * lpd[1] - lp0[0] * lpd[0] - lp0[1] * lpd[1]) / (Math.pow(lpd[0], 2.0) + Math.pow(lpd[1], 2.0));
        double d2 = Math.pow(lp0[0] + tMin * (lp1[0] - lp0[0]) - x[0], 2.0) + Math.pow(lp0[1] + tMin * (lp1[1] - lp0[1]) - x[1], 2.0);
        return Math.sqrt(d2);
    }

    private double[][] getClipPoints(Element clip) throws EmbedAndCropException {
        double[][] p;
        ArrayList<double[][]> pA = new ArrayList<double[][]>();
        NodeList children = clip.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            Element child = (Element)children.item(i);
            String baseTransform = child.getAttribute("transform");
            p = null;
            if (!child.getNodeName().equals("rect")) {
                throw new EmbedAndCropException("Can't get points from element type " + child.getNodeName());
            }
            p = this.rectBoundsToPointList(this.getRectBounds(child));
            if (p == null) continue;
            if (baseTransform != null && !baseTransform.equals("")) {
                for (int j = 0; j < 4; ++j) {
                    p[j] = this.parseTransform(p[j], baseTransform);
                }
            }
            pA.add(p);
        }
        int n = 0;
        for (int i = 0; i < pA.size(); ++i) {
            n += ((double[][])pA.get(i)).length;
        }
        double[][] points = new double[n][2];
        n = 0;
        for (int i = 0; i < pA.size(); ++i) {
            p = (double[][])pA.get(i);
            System.arraycopy(p, 0, points, 0, p.length);
            n += p.length;
        }
        return points;
    }

    private double[][] getPathPointList(Element path) throws EmbedAndCropException {
        if (path == null) {
            throw new EmbedAndCropException("Null path");
        }
        String d = path.getAttribute("d");
        if (d == null || d.equals("")) {
            throw new EmbedAndCropException("Empty path");
        }
        String[] dd = d.split("[^\\d\\.]");
        int n = 0;
        for (int i = 0; i < dd.length; ++i) {
            if (dd[i].equals("")) continue;
            ++n;
        }
        double[][] p = new double[n / 2][2];
        return p;
    }

    private double[] getRectBounds(Element e) {
        double[] p0 = new double[]{new Double(e.getAttribute("x")), new Double(e.getAttribute("y"))};
        double[] p1 = new double[]{p0[0] + new Double(e.getAttribute("width")), p0[1] + new Double(e.getAttribute("height"))};
        double[] r = new double[]{p0[0], p1[0], p0[1], p1[1]};
        return r;
    }

    private double[][] rectBoundsToPointList(double[] b) {
        double[][] p = new double[4][2];
        p[0][0] = b[0];
        p[0][1] = b[2];
        p[1][0] = b[0];
        p[1][1] = b[3];
        p[2][0] = b[1];
        p[2][1] = b[2];
        p[3][0] = b[1];
        p[3][1] = b[3];
        return p;
    }

    private double[] transformToDocumentSpace(double[] point, Node n) {
        Node parent;
        Element e;
        String transform;
        if (n.getNodeType() == 1 && (transform = (e = (Element)n).getAttribute("transform")) != null && !transform.equals("")) {
            point = this.parseTransform(point, transform);
        }
        if ((parent = n.getParentNode()) != null) {
            point = this.transformToDocumentSpace(point, parent);
        }
        return point;
    }

    private double[][] transformToDocumentSpace(double[][] points, Node n) {
        Node parent;
        Element e;
        String transform;
        if (n.getNodeType() == 1 && (transform = (e = (Element)n).getAttribute("transform")) != null && !transform.equals("")) {
            for (int i = 0; i < points.length; ++i) {
                double[] point = points[i];
                point = this.parseTransform(point, transform);
                points[i] = point;
            }
        }
        if ((parent = n.getParentNode()) != null) {
            points = this.transformToDocumentSpace(points, parent);
        }
        return points;
    }

    private double[] parseTransform(double[] point, String transform) {
        if (transform == null || transform.equals("")) {
            return point;
        }
        transform = transform.trim();
        String[] tList = transform.split("\\s");
        for (int i = 0; i < tList.length; ++i) {
            String[] u;
            String t = tList[i].trim();
            if (t.startsWith("matrix(")) {
                t = t.substring(t.indexOf("(") + 1, t.lastIndexOf(")"));
                u = t.split(",");
                double[] m = new double[]{new Double(u[0]), new Double(u[2]), new Double(u[4]), new Double(u[1]), new Double(u[3]), new Double(u[5])};
                point = this.transformMatrix(point, m);
                continue;
            }
            if (t.startsWith("translate(")) {
                t = t.substring(t.indexOf("(") + 1, t.lastIndexOf(")"));
                u = t.split(",");
                double tx = new Double(u[0]);
                double ty = u.length > 1 ? new Double(u[1]) : 0.0;
                point = this.transformTranslate(point, tx, ty);
                continue;
            }
            if (t.startsWith("scale(")) {
                t = t.substring(t.indexOf("(") + 1, t.lastIndexOf(")"));
                u = t.split(",");
                double sx = new Double(u[0]);
                double sy = u.length > 1 ? new Double(u[1]).doubleValue() : new Double(u[0]).doubleValue();
                point = this.transformScale(point, sx, sy);
                continue;
            }
            if (t.startsWith("rotate(")) {
                t = t.substring(t.indexOf("(") + 1, t.lastIndexOf(")"));
                u = t.split(",");
                double a = new Double(u[0]);
                if (u.length == 1) {
                    point = this.transformRotate(point, a);
                    continue;
                }
                if (u.length != 3) continue;
                double cx = new Double(u[1]);
                double cy = new Double(u[2]);
                point = this.transformRotate(point, a, cx, cy);
                continue;
            }
            if (t.startsWith("skewX(")) {
                t = t.substring(t.indexOf("(") + 1, t.lastIndexOf(")"));
                point = this.transformSkewX(point, new Double(t));
                continue;
            }
            if (!t.startsWith("skewY(")) continue;
            t = t.substring(t.indexOf("(") + 1, t.lastIndexOf(")"));
            point = this.transformSkewY(point, new Double(t));
        }
        return point;
    }

    private double[] transformMatrix(double[] point, double[] matrix) {
        if (point == null || matrix == null || point.length != 2 || matrix.length != 6) {
            throw new IllegalArgumentException("Malformed matrices - point: " + point + "; matrix: " + matrix);
        }
        double[] r = new double[]{point[0] * matrix[0] + point[1] * matrix[1] + 1.0 * matrix[2], point[0] * matrix[3] + point[1] * matrix[4] + 1.0 * matrix[5]};
        return r;
    }

    private double[] transformTranslate(double[] point, double tx, double ty) {
        double[] matrix = new double[]{1.0, 0.0, tx, 0.0, 1.0, ty};
        return this.transformMatrix(point, matrix);
    }

    private double[] transformScale(double[] point, double sx, double sy) {
        double[] matrix = new double[]{sx, 0.0, 0.0, 0.0, sy, 0.0};
        return this.transformMatrix(point, matrix);
    }

    private double[] transformRotate(double[] point, double a) {
        a = a * Math.PI / 180.0;
        double[] matrix = new double[]{Math.cos(a), -Math.sin(a), 0.0, Math.sin(a), Math.cos(a), 0.0};
        return this.transformMatrix(point, matrix);
    }

    private double[] transformRotate(double[] point, double a, double cx, double cy) {
        return this.transformTranslate(this.transformRotate(this.transformTranslate(point, cx, cy), a), -cx, -cy);
    }

    private double[] transformSkewX(double[] point, double a) {
        a = a * Math.PI / 180.0;
        double[] matrix = new double[]{1.0, Math.tan(a), 0.0, 0.0, 1.0, 0.0};
        return this.transformMatrix(point, matrix);
    }

    private double[] transformSkewY(double[] point, double a) {
        a = a * Math.PI / 180.0;
        double[] matrix = new double[]{1.0, 0.0, 0.0, Math.tan(a), 1.0, 0.0};
        return this.transformMatrix(point, matrix);
    }

    private Element getClipPath(Element img, Document dom) {
        String clip = img.getAttribute("clip-path");
        if (clip == null || clip.equals("")) {
            return null;
        }
        int a = clip.indexOf("#");
        int b = clip.indexOf(")");
        if (a >= 0 && b >= 0) {
            clip = clip.substring(a + 1, b);
        }
        System.err.println("Image has clip-path " + clip);
        NodeList clips = dom.getElementsByTagName("clipPath");
        Element clipElement = null;
        for (int i = 0; i < clips.getLength(); ++i) {
            if (!((Element)clips.item(i)).getAttribute("id").equals(clip)) continue;
            clipElement = (Element)clips.item(i);
            break;
        }
        return clipElement;
    }

    private File openDialog() {
        JFileChooser fc = new JFileChooser();
        if (fc.showOpenDialog(null) != 0) {
            return null;
        }
        return fc.getSelectedFile();
    }

    private Document readSVG(File f) throws EmbedAndCropException {
        Document svg;
        DocumentBuilder db;
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new EmbedAndCropException("Can't deal with XML: " + e.getMessage());
        }
        try {
            svg = db.parse(f);
        }
        catch (Throwable t) {
            throw new EmbedAndCropException("Can't read file: " + t.getMessage());
        }
        return svg;
    }

    private long processFileSize(String s) {
        long multiplier;
        String unit;
        Double value = Double.valueOf(s.replaceAll("\\D", "").trim());
        switch (unit = s.replaceAll("\\d", "").trim().toUpperCase()) {
            case "B": {
                multiplier = 1L;
                break;
            }
            case "KB": {
                multiplier = 1024L;
                break;
            }
            case "MB": {
                multiplier = 0x100000L;
                break;
            }
            case "GB": {
                multiplier = 0x40000000L;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid file size unit: " + unit);
            }
        }
        return value.longValue() * multiplier;
    }

    public void test() throws EmbedAndCropException {
        Document dom = this.readSVG(this.openDialog());
        this.getOutputParams();
        this.process(dom, "");
        this.saveAs(dom);
    }

    public static void main(String[] args) {
        EmbedAndCrop ec = new EmbedAndCrop();
        try {
            ec.runInkscapeExtension(args);
        }
        catch (Throwable t) {
            t.printStackTrace();
            JOptionPane.showMessageDialog(null, t.getMessage(), "Error", 0);
            System.exit(1);
        }
        System.exit(0);
    }
}

