/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Menus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import ij.plugin.CompilerTool;
import ij.plugin.PlugIn;
import ij.plugin.PlugInExecuter;
import ij.plugin.frame.Editor;
import java.awt.Font;
import java.io.File;
import java.io.FilenameFilter;
import java.io.StringWriter;
import java.util.Locale;
import java.util.Vector;

public class Compiler
implements PlugIn,
FilenameFilter {
    private static final int TARGET14 = 0;
    private static final int TARGET15 = 1;
    private static final int TARGET16 = 2;
    private static final int TARGET17 = 3;
    private static final String[] targets = new String[]{"1.4", "1.5", "1.6", "1.7"};
    private static final String TARGET_KEY = "javac.target";
    private static CompilerTool compilerTool;
    private static String dir;
    private static String name;
    private static Editor errors;
    private static boolean generateDebuggingInfo;
    private static int target;

    public void run(String arg) {
        if (arg.equals("edit")) {
            this.edit();
        } else if (arg.equals("options")) {
            this.showDialog();
        } else {
            this.compileAndRun(arg);
        }
    }

    void edit() {
        Editor ed;
        if (this.open("", "Open macro or plugin") && (ed = (Editor)IJ.runPlugIn("ij.plugin.frame.Editor", "")) != null) {
            ed.open(dir, name);
        }
    }

    void compileAndRun(String path) {
        if (!this.open(path, "Compile and Run Plugin...")) {
            return;
        }
        if (name.endsWith(".class")) {
            this.runPlugin(name.substring(0, name.length() - 1));
            return;
        }
        if (!this.isJavac()) {
            return;
        }
        if (this.compile(dir + name)) {
            this.runPlugin(name);
        }
    }

    boolean isJavac() {
        if (compilerTool == null) {
            compilerTool = CompilerTool.getDefault();
        }
        if (compilerTool != null) {
            return true;
        }
        IJ.error("Unable to find javac.jar, which is included with ImageJ\ndistributions bundled with Java, in the jre/lib/ext folder.\n \n\t java.home: " + System.getProperty("java.home"));
        return false;
    }

    boolean compile(String path) {
        IJ.showStatus("compiling " + path);
        String classpath = this.getClassPath(path);
        Vector<String> options = new Vector<String>();
        if (generateDebuggingInfo) {
            options.addElement("-g");
        }
        if (IJ.isJava15()) {
            this.validateTarget();
            options.addElement("-source");
            options.addElement(targets[target]);
            options.addElement("-target");
            options.addElement(targets[target]);
            options.addElement("-Xlint:unchecked");
        }
        options.addElement("-deprecation");
        options.addElement("-classpath");
        options.addElement(classpath);
        Vector<String> sources = new Vector<String>();
        sources.add(path);
        if (IJ.debugMode) {
            int i;
            StringBuilder builder = new StringBuilder();
            builder.append("javac");
            for (i = 0; i < options.size(); ++i) {
                builder.append(" ");
                builder.append(options.get(i));
            }
            for (i = 0; i < sources.size(); ++i) {
                builder.append(" ");
                builder.append(sources.get(i));
            }
            IJ.log(builder.toString());
        }
        boolean errors = true;
        String s = "not compiled";
        if (compilerTool != null) {
            StringWriter outputWriter = new StringWriter();
            errors = !compilerTool.compile(sources, options, outputWriter);
            s = outputWriter.toString();
        } else {
            errors = true;
        }
        if (errors) {
            this.showErrors(s);
        } else {
            IJ.showStatus("done");
        }
        return !errors;
    }

    String getClassPath(String path) {
        String pluginsDir;
        long start = System.currentTimeMillis();
        StringBuffer sb = new StringBuffer();
        sb.append(System.getProperty("java.class.path"));
        File f = new File(path);
        if (f != null) {
            sb.append(File.pathSeparator + f.getParent());
        }
        if ((pluginsDir = Menus.getPlugInsPath()) != null) {
            this.addJars(pluginsDir, sb);
        }
        return sb.toString();
    }

    void addJars(String path, StringBuffer sb) {
        String[] list = null;
        File f = new File(path);
        if (f.exists() && f.isDirectory()) {
            list = f.list();
        }
        if (list == null) {
            return;
        }
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        for (int i = 0; i < list.length; ++i) {
            File f2 = new File(path + list[i]);
            if (f2.isDirectory()) {
                this.addJars(path + list[i], sb);
                continue;
            }
            if (!list[i].endsWith(".jar") || list[i].indexOf("_") != -1 && !list[i].equals("loci_tools.jar")) continue;
            sb.append(File.pathSeparator + path + list[i]);
            if (!IJ.debugMode) continue;
            IJ.log("javac: " + path + list[i]);
        }
    }

    void showErrors(String s) {
        if (errors == null || !errors.isVisible()) {
            errors = (Editor)IJ.runPlugIn("ij.plugin.frame.Editor", "");
            errors.setFont(new Font("Monospaced", 0, 12));
        }
        if (errors != null) {
            errors.display("Errors", s);
        }
        IJ.showStatus("done (errors)");
    }

    boolean open(String path, String msg) {
        boolean okay;
        String fileName;
        String directory;
        if (path.equals("")) {
            String lcName;
            if (dir == null) {
                dir = IJ.getDirectory("plugins");
            }
            OpenDialog od = new OpenDialog(msg, dir, name);
            directory = od.getDirectory();
            fileName = od.getFileName();
            okay = fileName != null;
            String string = lcName = okay ? fileName.toLowerCase(Locale.US) : null;
            if (okay) {
                if (msg.startsWith("Compile")) {
                    if (!lcName.endsWith(".java") && !lcName.endsWith(".class")) {
                        IJ.error("File name must end with \".java\" or \".class\".");
                        okay = false;
                    }
                } else if (!(lcName.endsWith(".java") || lcName.endsWith(".txt") || lcName.endsWith(".ijm") || lcName.endsWith(".js"))) {
                    IJ.error("File name must end with \".java\", \".txt\" or \".js\".");
                    okay = false;
                }
            }
        } else {
            int i = path.lastIndexOf(47);
            if (i == -1) {
                i = path.lastIndexOf(92);
            }
            if (i > 0) {
                directory = path.substring(0, i + 1);
                fileName = path.substring(i + 1);
            } else {
                directory = "";
                fileName = path;
            }
            okay = true;
        }
        if (okay) {
            name = fileName;
            dir = directory;
            Editor.setDefaultDirectory(dir);
        }
        return okay;
    }

    public boolean accept(File dir, String name) {
        return name.endsWith(".java") || name.endsWith(".macro") || name.endsWith(".txt");
    }

    void runPlugin(String name) {
        name = name.substring(0, name.length() - 5);
        new PlugInExecuter(name);
    }

    public void showDialog() {
        this.validateTarget();
        GenericDialog gd = new GenericDialog("Compile and Run");
        gd.addChoice("Target: ", targets, targets[target]);
        gd.setInsets(15, 5, 0);
        gd.addCheckbox("Generate debugging info (javac -g)", generateDebuggingInfo);
        gd.addHelp("http://imagej.nih.gov/ij/docs/menus/edit.html#compiler");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        target = gd.getNextChoiceIndex();
        generateDebuggingInfo = gd.getNextBoolean();
        this.validateTarget();
    }

    void validateTarget() {
        if (target < 0 || target > 3) {
            target = 1;
        }
        if (target > 2 && !IJ.isJava17() || target > 1 && !IJ.isJava16()) {
            target = 1;
        }
        if (!IJ.isJava15()) {
            target = 0;
        }
        Prefs.set(TARGET_KEY, target);
    }

    static {
        target = (int)Prefs.get(TARGET_KEY, 1.0);
    }
}

